// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     chrome/common/resource_usage_reporter.mojom
//

package org.chromium.mojom;

public final class ResourceTypeStats extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 56;
    private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(56, 0)};
    private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

    public ResourceTypeStat images;
    public ResourceTypeStat cssStyleSheets;
    public ResourceTypeStat scripts;
    public ResourceTypeStat xslStyleSheets;
    public ResourceTypeStat fonts;
    public ResourceTypeStat other;

    private ResourceTypeStats(int version) {
        super(STRUCT_SIZE, version);
    }

    public ResourceTypeStats() {
        this(0);
    }

    public static ResourceTypeStats deserialize(org.chromium.mojo.bindings.Message message) {
        return decode(new org.chromium.mojo.bindings.Decoder(message));
    }

    @SuppressWarnings("unchecked")
    public static ResourceTypeStats decode(org.chromium.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
        ResourceTypeStats result = new ResourceTypeStats(mainDataHeader.elementsOrVersion);
        if (mainDataHeader.elementsOrVersion >= 0) {
            org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
            result.images = ResourceTypeStat.decode(decoder1);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(16, false);
            result.cssStyleSheets = ResourceTypeStat.decode(decoder1);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(24, false);
            result.scripts = ResourceTypeStat.decode(decoder1);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(32, false);
            result.xslStyleSheets = ResourceTypeStat.decode(decoder1);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(40, false);
            result.fonts = ResourceTypeStat.decode(decoder1);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(48, false);
            result.other = ResourceTypeStat.decode(decoder1);
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        encoder0.encode(images, 8, false);
        encoder0.encode(cssStyleSheets, 16, false);
        encoder0.encode(scripts, 24, false);
        encoder0.encode(xslStyleSheets, 32, false);
        encoder0.encode(fonts, 40, false);
        encoder0.encode(other, 48, false);
    }

    /**
     * @see Object#equals(Object)
     */
    @Override
    public boolean equals(Object object) {
        if (object == this)
            return true;
        if (object == null)
            return false;
        if (getClass() != object.getClass())
            return false;
        ResourceTypeStats other = (ResourceTypeStats) object;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.images, other.images))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.cssStyleSheets, other.cssStyleSheets))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.scripts, other.scripts))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.xslStyleSheets, other.xslStyleSheets))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.fonts, other.fonts))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.other, other.other))
            return false;
        return true;
    }

    /**
     * @see Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = prime + getClass().hashCode();
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(images);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(cssStyleSheets);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(scripts);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(xslStyleSheets);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(fonts);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(other);
        return result;
    }
}

